IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[PG_FORN_PROC_MCC_OBSERVACAO]') 
					AND type in (N'U')) 

BEGIN

	CREATE TABLE [dbo].[PG_FORN_PROC_MCC_OBSERVACAO](
		[CD_EMP]	[int] NOT NULL,
		[CD_FORN] [int] NOT NULL,
		[DT_PROC] [datetime] NOT NULL,
		[LINHA] [int] NOT NULL,
		[OBSERVACAO] [nvarchar](max) NULL,
		
		
	CONSTRAINT [PK_PG_FORN_PROC_MCC_OBSERVACAO] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FORN] ASC,
		[DT_PROC] ASC,
		[LINHA] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
	
	ALTER TABLE [dbo].[PG_FORN_PROC_MCC_OBSERVACAO]  WITH CHECK ADD  CONSTRAINT [FK_PG_FORN_PROC_MCC_OBSERVACAO_PG_FORN_PROC_MCC] FOREIGN KEY([CD_EMP], [CD_FORN], [DT_PROC])
	REFERENCES [dbo].[PG_FORN_PROC_MCC] ([CD_EMP], [CD_FORN], [DT_PROC])

	ALTER TABLE [dbo].[PG_FORN_PROC_MCC_OBSERVACAO] CHECK CONSTRAINT [FK_PG_FORN_PROC_MCC_OBSERVACAO_PG_FORN_PROC_MCC]
	
END